<?php

namespace console\controllers;

use yii\console\Controller;
use Yii;
use common\models\Bots;
use common\models\Commands;
use common\models\Files;
use common\models\Clones;
use yii\db\Expression;
use yii\helpers\FileHelper;

class FilesController extends Controller
{

    public function actionIndex()
    {
        $time = new \DateTime('NOW');
        $now = $time->format('Y-m-d H:i:s');
        $seconds_dead = 60 * 60 * 24; //  1 day
        $dead = gmdate('Y-m-d H:i:s',strtotime($now) - $seconds_dead);

        Yii::info('Robot '. 'Started at:'.$now);

        // delete all files older than 1 day
        $f = Files::find()->where(['<=', 'created_at', $dead])->andWhere(['destination' => null])->all();
        foreach ($f as $key => $value) {
            
            if(file_exists(Yii::getAlias('@absPath').$value['storedfilename'])){
                print_r('Delete file:'.$value['storedfilename'].chr(13).chr(10));
                unlink(Yii::getAlias('@absPath').$value['storedfilename']);

                Yii::info('Robot '. 'Delete file:'.$value['storedfilename']);
            }
            // delete clones
            $c = Clones::find()->where(['like', 'source', $value['storedfilename'] ])->andWhere(['clonetype' => 0])->all();
            if($c){
                foreach ($c as $k => $v) {
                    if(file_exists(Yii::getAlias('@absPath').'/api/web'.$v['clone'])){
                        print_r('     Delete clone:'.Yii::getAlias('@absPath').'/api/web'.$v['clone'].chr(13).chr(10));
                        unlink(Yii::getAlias('@absPath').'/api/web'.$v['clone']);
                        Yii::info('Robot '. 'Delete clone:'.Yii::getAlias('@absPath').'/api/web'.$v['clone']);

                        // delete commands 
                        $m = Commands::find()->where(['or',['commandtype' => 10],['commandtype' => 11] ])->all();
                        foreach ($m as $ke => $va) {
                            if(strpos($va['command'],$v['clone'])){
                                print_r('     '.'     Delete command:'.$va['command'].chr(13).chr(10));
                                Commands::deleteAll(['id'=>$va['id'] ]);
                                Yii::info('Robot '.'Delete command:'.$va['command'].' , '.$va['group']);
                            }
                        }
                    }
                    Clones::deleteAll(['id'=>$v['id'] ]);
                }
            }
            //$id = $value['id'];
            Files::deleteAll(['id'=>$value['id'] ]);
            
            
        }
        
    	// review files in storage (used for initialize comment for future)
        /*$files=\yii\helpers\FileHelper::findFiles(Yii::getAlias('@absPath').'/filesStorage');
        foreach ($files as $key => $value) {
            $basepath = substr($value,strpos($value, '/filesStorage'));
            $b = Files::findOne(['storedfilename'=>$basepath]);
            if($b){
                $b->hashmd5 = md5_file($value);
                $b->save(false);
            }
        }*/

        // find doubles
        /*$model = Files::find()->orderBy(['group' => SORT_ASC,'hashmd5'=>SORT_ASC,'filename'=>SORT_ASC])->all();
        $g = '';
        $h = '';
        $f = '';
        $s = '';
        foreach ($model as $key => $value) {
            if($g!=$value->group || $h!=$value->hashmd5 || $f!=$value->filename){
                $g = $value->group;
                $h = $value->hashmd5;
                $f = $value->filename;
                
            }else{
                // mark doubles
                if($value->current!=1){
                    $g1 = Files::findOne(['storedfilename' => $value->storedfilename]);
                    $g1->bots = 'x';
                    $g1->save(false);

                    // delete files
                    if (file_exists(Yii::getAlias('@absPath').$value->storedfilename)) {
                        unlink(Yii::getAlias('@absPath').$value->storedfilename);
                    }
                }
            }
        }
        // clear rows
        Files::deleteAll(['bots'=>'x']);*/

        exit();
    }

}
